/***************************************************************************/
/*  USART0 (polling) driver for NXP LPC15xx microcontrollers.             */
/***************************************************************************/
#include "LPC15xx.h"                                   // LPC15xx definitions
#include "global.h"

const char ascii[] = "0123456789ABCDEF";

void USART0_Init(uint32_t br)
/***************************/
{
    LPC_SYSCON->SYSAHBCLKCTRL1 |= (1 << 17);           // Enable USART0 clock
    LPC_SYSCON->PRESETCTRL1    &= ~(1 << 17);          // de-assert USART0 reset
    LPC_SWM->PINASSIGN0 |= 0x0000FFFF;                 // ASSIGN0(15:0) = FFFF
    LPC_SWM->PINASSIGN0 &= 0xFFFFFF46;                 // assign U0 TXD to P2_6 ASSIGN0(7:0)
    LPC_SWM->PINASSIGN0 &= 0xFFFF47FF;                 // assign U0_RXD to P2_7 ASSIGN0(15:8)
	
    LPC_SYSCON->UARTCLKDIV      = 1;                   // divided by 1
	
    LPC_UART0->BRG = (SystemCoreClock/16/br)-1;        // baud rate
    LPC_UART0->CFG = (1<<0)|(1<<2);                    // 8 bits, no Parity, 1 Stop bit
}

char ua_inchar(void)	                                 // look if there is a character available
/******************/
{
    if (LPC_UART0->STAT & (1<<0))
        return LPC_UART0->RXDATA & 0x7F;               // yes, return character from input buffer
    else
        return 0xFF;                                   // no, return -1
}

char ua_getchar(void)                                  // wait for a character
/*******************/
{
    while (!(LPC_UART0->STAT & (1<<0))) ;              // receiver ready?
    return LPC_UART0->RXDATA & 0x7F;                   // read character from input buffer
}

void ua_outchar(char c)		
/*********************/
{
	  while (!(LPC_UART0->STAT & (1<<2))) ;              // transmitter ready?
    LPC_UART0->TXDATA = c;
}

void PrintByte(unsigned char b)
/*****************************/
{
    ua_outchar(ascii[b >> 4]);
    ua_outchar(ascii[b & 0x0f]);
}

void PrintWord(unsigned short w)
/******************************/
{
    PrintByte((unsigned char)(w>>8));
    PrintByte((unsigned char)w);
}

void PrintString(const char *s)
/*****************************/
{
    while (*s)
    {
        if (*s == '\n')
            ua_outchar('\r');                      // output a '\r' first
        ua_outchar(*s);
        s++;
    }
}
